unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, IniFiles;

type
  TFormMain = class(TForm)
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
  private
    function WinExecAndWait32(FileName:String):integer;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

function TFormMain.WinExecAndWait32(FileName:String):integer;
var
  zAppName:array[0..512] of char;
  zCurDir:array[0..255] of char;
  WorkDir:String;
  StartupInfo:TStartupInfo;
  ProcessInfo:TProcessInformation;
begin
  StrPCopy(zAppName,FileName);
  GetDir(0,WorkDir);
  StrPCopy(zCurDir,WorkDir);
  FillChar(StartupInfo,Sizeof(StartupInfo),#0);
  StartupInfo.cb := Sizeof(StartupInfo);

  StartupInfo.dwFlags := STARTF_RUNFULLSCREEN or IDLE_PRIORITY_CLASS;
  StartupInfo.wShowWindow := SW_MAX;
  if CreateProcess(nil, zAppName, nil, nil, false,
                       CREATE_NEW_CONSOLE or NORMAL_PRIORITY_CLASS,
                       nil, nil, StartupInfo, ProcessInfo) then
  begin
    WaitforSingleObject(ProcessInfo.hProcess,INFINITE);
    GetExitCodeProcess(ProcessInfo.hProcess,Result);
  end
  else begin
    Result := -1
  end;
end;




procedure TFormMain.FormShow(Sender: TObject);
begin
  with TIniFile.Create('DPMS_SCR.INI') do begin
    if ReadBool('DPMS', 'Standby_Mode', false) then
      WinExecAndWait32('cmd.exe /c vesa.com 4')
    else
      WinExecAndWait32('cmd.exe /c vesa.com 1');
  end;
  Close;
end;

procedure TFormMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ShowCursor(true);
end;



procedure TFormMain.FormActivate(Sender: TObject);
begin
  top := 0;
  left := 0;
  WindowState := wsMaximized;
  ShowCursor(false);
end;

end.
